﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Data;

namespace WPF.PresentationLayer.Converters
{
    public class NullToBoolConverter : IValueConverter
    {
        public bool NullBool { get; set; }
        public bool NotNullBool { get; set; }

        public NullToBoolConverter()
        {
            NullBool = false;
            NotNullBool = true;
        }

        public object Convert(object value, Type targetType, object parameter, System.Globalization.CultureInfo culture)
        {
            if (value == null)
            {
                return NullBool;
            }
            else
            {
                return NotNullBool;
            }
        }

        public object ConvertBack(object value, Type targetType, object parameter, System.Globalization.CultureInfo culture)
        {
            throw new NotImplementedException();
        }
    }
}
